﻿Option Explicit On

Imports System.Runtime.InteropServices

Public Class Form1
    Public Const DIGCF_PRESENT = &H2
    Public Const DIGCF_DEVICEINTERFACE = &H10

    Public Const FORMAT_MESSAGE_FROM_SYSTEM = &H1000
    Public Const GENERIC_READ = &H80000000
    Public Const GENERIC_WRITE = &H40000000
    Public Const FILE_SHARE_READ = &H1
    Public Const FILE_SHARE_WRITE = &H2
    Public Const OPEN_EXISTING = 3
    Public Const INVALID_HANDLE_VALUE = -1

    Public Const MyVendorID = &H1352        'Km2Net
    'USB-FSIO:&h110     USB-FSIO30:&h111
    Public MyProductIDs() As Short = {&H110, &H111}

    <StructLayout(LayoutKind.Sequential, Pack:=1, CharSet:=CharSet.Ansi)> _
    Public Structure GUID
        Dim Data1 As Integer
        Dim Data2 As Short
        Dim Data3 As Short
        <MarshalAs(UnmanagedType.ByValArray, SizeConst:=8)> Dim Data4() As Byte
    End Structure

    <StructLayout(LayoutKind.Sequential, pack:=1)> _
    Public Structure HIDD_ATTRIBUTES
        Dim Size As Integer
        Dim VendorID As Short
        Dim ProductID As Short
        Dim VersionNumber As Short
    End Structure

    <StructLayout(LayoutKind.Sequential, pack:=1)> _
    Public Structure HIDP_CAPS
        Dim Usage As Short
        Dim UsagePage As Short
        Dim InputReportByteLength As Short
        Dim OutputReportByteLength As Short
        Dim FeatureReportByteLength As Short
        <MarshalAs(UnmanagedType.ByValArray, SizeConst:=16)> Dim Reserved() As Short
        Dim NumberLinkCollectionNodes As Short
        Dim NumberInputButtonCaps As Short
        Dim NumberInputValueCaps As Short
        Dim NumberInputDataIndices As Short
        Dim NumberOutputButtonCaps As Short
        Dim NumberOutputValueCaps As Short
        Dim NumberOutputDataIndices As Short
        Dim NumberFeatureButtonCaps As Short
        Dim NumberFeatureValueCaps As Short
        Dim NumberFeatureDataIndices As Short
    End Structure

    <StructLayout(LayoutKind.Sequential, pack:=1)> _
    Public Structure SECURITY_ATTRIBUTES
        Dim nLength As Integer
        Dim lpSecurityDescriptor As Integer
        Dim bInheritHandle As Integer
    End Structure

    <StructLayout(LayoutKind.Sequential, Pack:=1, CharSet:=CharSet.Ansi)> _
    Public Structure SP_DEVICE_INTERFACE_DATA
        Dim cbSize As Integer
        Dim InterfaceClassGuid As GUID
        Dim Flags As Integer
        Dim Reserved As Integer
    End Structure

    <StructLayout(LayoutKind.Sequential, Pack:=1, CharSet:=CharSet.Ansi)> _
    Public Structure SP_DEVINFO_DATA
        Dim cbSize As Integer
        Dim ClassGuid As GUID
        Dim DevInst As Integer
        Dim Reserved As Integer
    End Structure

    <StructLayout(LayoutKind.Sequential, pack:=1)> _
    Public Structure SP_DEVICE_INTERFACE_DETAIL_DATA
        Dim cbSize As Integer
        Dim DevicePath As Byte
    End Structure




    Public Declare Function CloseHandle Lib "kernel32" (ByVal hObject As Integer) As Integer

    Public Declare Function CreateFile _
        Lib "kernel32" _
        Alias "CreateFileA" _
        (ByVal lpFileName As String, _
        ByVal dwDesiredAccess As Integer, _
        ByVal dwShareMode As Integer, _
        ByRef lpSecurityAttributes As SECURITY_ATTRIBUTES, _
        ByVal dwCreationDisposition As Integer, _
        ByVal dwFlagsAndAttributes As Integer, _
        ByVal hTemplateFile As Integer) _
    As Integer

    Public Declare Function FormatMessage _
        Lib "kernel32" _
        Alias "FormatMessageA" _
        (ByVal dwFlags As Integer, _
        ByRef lpSource As Integer, _
        ByVal dwMessageId As Integer, _
        ByVal dwLanguageZId As Integer, _
        ByVal lpBuffer As String, _
        ByVal nSize As Integer, _
        ByVal Arguments As Integer) _
    As Integer

    Public Declare Function HidD_FreePreparsedData _
        Lib "hid.dll" _
        (ByRef PreparsedData As Integer) _
    As Integer

    Public Declare Function HidD_GetAttributes _
        Lib "hid.dll" _
        (ByVal HidDeviceObject As Integer, _
        ByRef Attributes As HIDD_ATTRIBUTES) _
    As Integer

    Public Declare Function HidD_GetHidGuid _
        Lib "hid.dll" _
        (ByRef HidGuid As GUID) _
    As Integer

    Public Declare Function HidD_GetPreparsedData _
        Lib "hid.dll" _
        (ByVal HidDeviceObject As Integer, _
        ByRef PreparsedData As Integer) _
    As Integer

    Public Declare Function HidP_GetCaps _
        Lib "hid.dll" _
        (ByVal PreparsedData As Integer, _
        ByRef Capabilities As HIDP_CAPS) _
    As Integer

    Public Declare Function HidP_GetValueCaps _
        Lib "hid.dll" _
        (ByVal ReportType As Short, _
        ByRef ValueCaps As Byte, _
        ByRef ValueCapsLength As Short, _
        ByVal PreparsedData As Integer) _
    As Integer

    Public Declare Function lstrcpy _
        Lib "kernel32" _
        Alias "lstrcpyA" _
        (ByVal dest As String, _
        ByVal source As Integer) _
    As String

    Public Declare Function lstrlen _
        Lib "kernel32" _
        Alias "lstrlenA" _
        (ByVal source As Integer) _
    As Integer

    Public Declare Function ReadFile _
        Lib "kernel32" _
        (ByVal hFile As Integer, _
        ByRef lpBuffer As Byte, _
        ByVal nNumberOfBytesToRead As Integer, _
        ByRef lpNumberOfBytesRead As Integer, _
        ByVal lpOverlapped As Integer) _
    As Integer

    Public Declare Sub RtlMoveMemory Lib "kernel32" (ByRef Destination As Byte, ByVal Source As IntPtr, ByVal Length As Short)

    Public Declare Function SetupDiCreateDeviceInfoList _
        Lib "setupapi.dll" _
        (ByRef ClassGuid As GUID, _
        ByVal hwndParent As Integer) _
    As Integer

    Public Declare Function SetupDiDestroyDeviceInfoList _
        Lib "setupapi.dll" _
        (ByVal DeviceInfoSet As Integer) _
    As Integer

    Public Declare Function SetupDiEnumDeviceInterfaces _
        Lib "setupapi.dll" _
        (ByVal DeviceInfoSet As Integer, _
        ByVal DeviceInfoData As Integer, _
        ByRef InterfaceClassGuid As GUID, _
        ByVal MemberIndex As Integer, _
        ByRef DeviceInterfaceData As SP_DEVICE_INTERFACE_DATA) _
    As Integer

    Public Declare Function SetupDiGetClassDevs _
        Lib "setupapi.dll" _
        Alias "SetupDiGetClassDevsA" _
        (ByRef ClassGuid As GUID, _
        ByVal Enumerator As String, _
        ByVal hwndParent As Integer, _
        ByVal Flags As Integer) _
    As Integer

    Public Declare Function SetupDiGetDeviceInterfaceDetail _
       Lib "setupapi.dll" _
       Alias "SetupDiGetDeviceInterfaceDetailA" _
       (ByVal DeviceInfoSet As Integer, _
       ByRef DeviceInterfaceData As SP_DEVICE_INTERFACE_DATA, _
       ByVal DeviceInterfaceDetailData As Integer, _
       ByVal DeviceInterfaceDetailDataSize As Integer, _
       ByRef RequiredSize As Integer, _
       ByVal DeviceInfoData As Integer) _
    As Integer

    Public Declare Function WriteFile _
        Lib "kernel32" _
        (ByVal hFile As Integer, _
        ByRef lpBuffer As Byte, _
        ByVal nNumberOfBytesToWrite As Integer, _
        ByRef lpNumberOfBytesWritten As Integer, _
        ByVal lpOverlapped As Integer) _
    As Integer

    Public Declare Function GetTickCount Lib "kernel32" () As Integer





    Public HidDevice As Integer = INVALID_HANDLE_VALUE
    Public Capabilities As HIDP_CAPS
    Public bControlFirst As Boolean = False

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim s As System.Drawing.Size = Me.Size
        s.Width = 256
        Me.Size = s
    End Sub


    Private Sub btnConnect_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnConnect.Click
        Dim HidGuid As GUID
        Dim DeviceInfoSet As Integer
        Dim MyDeviceInterfaceData As SP_DEVICE_INTERFACE_DATA
        Dim MemberIndex As Integer
        Dim MyDeviceInfoData As SP_DEVINFO_DATA
        Dim Needed As Integer
        Dim DetailData As Integer
        Dim MyDeviceInterfaceDetailData As SP_DEVICE_INTERFACE_DETAIL_DATA
        Dim DetailDataBuffer() As Byte
        Dim gch As GCHandle
        Dim address As Integer
        Dim DevicePathName As String
        Dim sa As SECURITY_ATTRIBUTES
        Dim DeviceAttributes As HIDD_ATTRIBUTES
        Dim PreparsedData As Long

        Dim ipt As IntPtr
        Dim Result As Integer

        Result = HidD_GetHidGuid(HidGuid)
        DeviceInfoSet = SetupDiGetClassDevs _
            (HidGuid, vbNullString, 0, (DIGCF_PRESENT Or DIGCF_DEVICEINTERFACE))

        MemberIndex = 0

        Do
            MyDeviceInterfaceData.cbSize = Marshal.SizeOf(MyDeviceInterfaceData)
            Result = SetupDiEnumDeviceInterfaces _
                (DeviceInfoSet, 0, HidGuid, MemberIndex, MyDeviceInterfaceData)

            If Result <> 0 Then
                MyDeviceInfoData.cbSize = Marshal.SizeOf(MyDeviceInfoData)
                Result = SetupDiGetDeviceInterfaceDetail _
                   (DeviceInfoSet, MyDeviceInterfaceData, 0, 0, Needed, 0)

                DetailData = Needed
                MyDeviceInterfaceDetailData.cbSize = Marshal.SizeOf(MyDeviceInterfaceDetailData)
                ReDim DetailDataBuffer(Needed)
                ipt = Marshal.AllocHGlobal(Marshal.SizeOf(MyDeviceInterfaceDetailData))
                Marshal.StructureToPtr(MyDeviceInterfaceDetailData, ipt, False)
                Call RtlMoveMemory(DetailDataBuffer(0), ipt, 4)

                gch = GCHandle.Alloc(DetailDataBuffer, GCHandleType.Pinned)
                address = gch.AddrOfPinnedObject().ToInt32()

                Result = SetupDiGetDeviceInterfaceDetail _
                   (DeviceInfoSet, MyDeviceInterfaceData, address, DetailData, Needed, 0)

                gch.Free()

                DevicePathName = System.Text.Encoding.GetEncoding("Shift-JIS").GetString(DetailDataBuffer)
                DevicePathName = DevicePathName.Substring(4)

                sa.nLength = 12
                sa.lpSecurityDescriptor = 0
                sa.bInheritHandle = 0

                HidDevice = CreateFile(DevicePathName, GENERIC_READ Or GENERIC_WRITE, (FILE_SHARE_READ Or FILE_SHARE_WRITE), _
                                        sa, OPEN_EXISTING, 0, 0)

                If HidDevice <> INVALID_HANDLE_VALUE Then
                    DeviceAttributes.Size = Marshal.SizeOf(DeviceAttributes)
                    Result = HidD_GetAttributes(HidDevice, DeviceAttributes)

                    If (DeviceAttributes.VendorID = MyVendorID) _
                        And (Array.IndexOf(MyProductIDs, DeviceAttributes.ProductID) >= 0) Then

                        HidD_GetPreparsedData(HidDevice, PreparsedData)
                        HidP_GetCaps(PreparsedData, Capabilities)

                        btnConnect.Enabled = False
                        btnSetting.Enabled = True
                        btnStart.Enabled = True
                        bControlFirst = True
                        Exit Do
                    Else
                        Result = CloseHandle(HidDevice)
                    End If

                End If
            Else
                Exit Do
            End If
            MemberIndex = MemberIndex + 1
        Loop

    End Sub


    Private Sub btnSetting_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSetting.Click
        If HidDevice <> INVALID_HANDLE_VALUE Then
            txtCmd.Text = "&hF9"        '設定登録

            txtSendData.Text = ""
            txtSendData.Text = txtSendData.Text & "&h05,"       ' 0:アナログ入力チャネル数5
            txtSendData.Text = txtSendData.Text & "&h00,"       ' 1:ポート２ プルアップ　0:有効
            txtSendData.Text = txtSendData.Text & "&h00,"       ' 2:
            txtSendData.Text = txtSendData.Text & "&h00,"       ' 3:
            txtSendData.Text = txtSendData.Text & "&h2F,"       ' 4:ポート１:入力ピン設定　0b00101111 ビットONが入力ピン
            txtSendData.Text = txtSendData.Text & "&hFF,"       ' 5:ポート２:入力ピン設定　0b11111111 ビットONが入力ピン
            txtSendData.Text = txtSendData.Text & "&h00,"       ' 6:ポート３:入力ピン設定　0b00000000 ビットONが入力ピン
            txtSendData.Text = txtSendData.Text & "&h00,"       ' 7:
            txtSendData.Text = txtSendData.Text & "&h00,"       ' 8:ポート１:初期出力設定　[0b00000000]
            txtSendData.Text = txtSendData.Text & "&h00,"       ' 9:ポート２:初期出力設定　[0b00000000]
            txtSendData.Text = txtSendData.Text & "&h00,"       '10:ポート３:初期出力設定　[0b00000000]
            txtSendData.Text = txtSendData.Text & "&h00,"       '11:
            txtSendData.Text = txtSendData.Text & "&h59,"       '12:パルス割込タイミング(式(1158 - n * 4) * (4 / 48)) n:[0x59]=66.83us　※nは3の倍数-1を指定
            txtSendData.Text = txtSendData.Text & "&h01,"       '13:PWM利用　              1:PWM利用
            txtSendData.Text = txtSendData.Text & "&h00,&h00,"  '14～15
            txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,"    '16～31
            txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,"    '32～47
            txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00"               '48～61

            SendRecv()
            CloseHandle(HidDevice)
            btnConnect.Enabled = True

            MessageBox.Show("USB-FSIOを抜差してください。")

            btnConnect.Enabled = True
            btnSetting.Enabled = False
            btnStart.Enabled = False

        End If

    End Sub

    Private Sub btnStart_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnStart.Click
        btnConnect.Enabled = False
        btnSetting.Enabled = False
        btnStart.Enabled = False
        timCtl.Enabled = True
    End Sub

    Private Sub timCtl_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles timCtl.Tick
        Dim RcvDt() As String

        txtCmd.Text = "&h2A"        'アナログ入力 CH1 CH5
        txtSendData.Text = ""
        txtSendData.Text = txtSendData.Text & "&h01,&h00,&h00,&h05,&h00,&h00,&h00,&h00, &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,"
        txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00, &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,"
        txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00, &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,"
        txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00, &h00,&h00,&h00,&h00,&h00,&h00"
        SendRecv()
        RcvDt = Split(txtRcvData.Text, ",")
        txtAn1.Text = (Trim(RcvDt(2)) * 256 + Trim(RcvDt(1))) * 5000 / 1023
        txtAn5.Text = (Trim(RcvDt(5)) * 256 + Trim(RcvDt(4))) * 5000 / 1023

        'アナログ値からPWM出力変更
        txtDuty1.Text = Int(txtAn1.Text / (5000 / 15) + 15)
        txtDuty5.Text = Int(txtAn5.Text / (5000 / 100))
        lblPeriod1.Text = txtPeriod1.Text * 66.83 & " us"
        lblDuty1.Text = txtDuty1.Text * 66.83 & " us"
        lblPeriod5.Text = txtPeriod5.Text * 66.83 & " us"
        lblDuty5.Text = txtDuty5.Text * 66.83 & " us"


        txtCmd.Text = "&h20"        'デジタル入力
        txtSendData.Text = ""
        txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00, &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,"
        txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00, &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,"
        txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00, &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,"
        txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00, &h00,&h00,&h00,&h00,&h00,&h00"
        SendRecv()
        RcvDt = Split(txtRcvData.Text, ",")
        Dim iWk As Integer = Trim(RcvDt(1))
        txtJ2.Text = "00000000" & Convert.ToString(iWk, 2)
        txtJ2.Text = txtJ2.Text.Substring(txtJ2.Text.Length - 8, 8)

        If bControlFirst = True Then
            txtCmd.Text = "&h40"        'PWM周期 CH1 CH5    初回のみ設定
            txtSendData.Text = ""
            txtSendData.Text = txtSendData.Text & Integer.Parse(Trim(txtPeriod1.Text) And &HFF).ToString & ","
            txtSendData.Text = txtSendData.Text & Integer.Parse(Trim(txtPeriod1.Text) >> 8 And &HFF).ToString & ","
            txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,"
            txtSendData.Text = txtSendData.Text & Integer.Parse(Trim(txtPeriod5.Text) And &HFF).ToString & ","
            txtSendData.Text = txtSendData.Text & Integer.Parse(Trim(txtPeriod5.Text) >> 8 And &HFF).ToString & ","
            txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,"
            txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00, &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,"
            txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00, &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,"
            txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00, &h00,&h00,&h00,&h00,&h00,&h00"
            SendRecv()
        End If

        txtCmd.Text = "&h41"        'PWM出力 CH1 CH5
        txtSendData.Text = ""
        txtSendData.Text = txtSendData.Text & Integer.Parse(Trim(txtDuty1.Text) And &HFF).ToString & ","
        txtSendData.Text = txtSendData.Text & Integer.Parse((Trim(txtDuty1.Text) >> 8) And &HFF).ToString & ","
        txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,"
        txtSendData.Text = txtSendData.Text & Integer.Parse(Trim(txtDuty5.Text) And &HFF).ToString & ","
        txtSendData.Text = txtSendData.Text & Integer.Parse((Trim(txtDuty5.Text) >> 8) And &HFF).ToString & ","
        txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,"
        txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00, &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,"
        txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00, &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,"
        txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00, &h00,&h00,&h00,&h00,&h00,&h00"
        SendRecv()

        If bControlFirst = True Then
            txtCmd.Text = "&h42"        'PWM ON (0001001)   初回のみ設定
            txtSendData.Text = ""
            txtSendData.Text = txtSendData.Text & "&h11,&h00,&h00,&h00,&h00,&h00,&h00,&h00, &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,"
            txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00, &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,"
            txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00, &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,"
            txtSendData.Text = txtSendData.Text & "&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00, &h00,&h00,&h00,&h00,&h00,&h00"
            SendRecv()
        End If

        bControlFirst = False

    End Sub





    Private Sub SendRecv()
        Dim txtBuf() As String
        Dim SendBuf() As Byte
        Dim RcvBuf() As Byte
        Dim i As Integer
        Dim s As String
        Dim NumberOfBytesWritten As Integer
        Dim NumberOfBytesRead As Integer

        On Error GoTo errJump

        ReDim SendBuf(Capabilities.OutputReportByteLength - 1)
        ReDim RcvBuf(Capabilities.InputReportByteLength - 1)

        txtBuf = Split(txtSendData.Text, ",")
        SendBuf(0) = 0
        SendBuf(1) = txtCmd.Text
        For i = 0 To UBound(txtBuf)
            SendBuf(i + 2) = Trim(txtBuf(i))
        Next
        SendBuf(64) = txtSendSeq.Text
        WriteFile(HidDevice, SendBuf(0), Capabilities.OutputReportByteLength, NumberOfBytesWritten, 0)

        Do
            ReadFile(HidDevice, RcvBuf(0), Capabilities.InputReportByteLength, NumberOfBytesRead, 0)
            If txtSendSeq.Text = RcvBuf(64) Then
                Exit Do
            End If
        Loop
        s = "0" & Hex(RcvBuf(1))
        txtRcvCmd.Text = "&h" & s.Substring(s.Length - 2)

        txtRcvData.Text = ""
        For i = 2 To UBound(RcvBuf) - 1
            If i > 2 Then
                txtRcvData.Text = txtRcvData.Text & ","
            End If
            s = "0" & Hex(RcvBuf(i))
            txtRcvData.Text = txtRcvData.Text & "&h" & s.Substring(s.Length - 2)
        Next

        s = "0" & Hex(RcvBuf(64))
        txtRcvSeq.Text = "&h" & s.Substring(s.Length - 2)

        Exit Sub

errJump:
        MsgBox(Err.Description)
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        If HidDevice <> INVALID_HANDLE_VALUE Then
            CloseHandle(HidDevice)
        End If
    End Sub

End Class
