#define USB_VENDOR          0x1352
#define USB_PID_IO_2_0      0x0120
#define USB_PID_IO_AKI      0x0121
#define USB_PID_FSIO_KIT    0x0110
#define USB_PID_FSIO30      0x0111

/* Init USB */
struct usb_bus *io_init()
{
    usb_init();
    usb_find_busses();
    usb_find_devices();
    return( usb_get_busses() );
}

/* Find Km2Net USB-IO Family */
struct usb_device *io_find(struct usb_bus *busses, struct usb_device *dev)
{
    struct usb_bus *bus;
    for(bus=busses; bus; bus=bus->next){
        for(dev=bus->devices; dev; dev=dev->next) {
            if ( dev->descriptor.idVendor  == USB_VENDOR
            &&   (   dev->descriptor.idProduct == USB_PID_IO_2_0
                  || dev->descriptor.idProduct == USB_PID_IO_AKI
                  || dev->descriptor.idProduct == USB_PID_FSIO_KIT
                  || dev->descriptor.idProduct == USB_PID_FSIO30) ){
                return( dev );
            }
        }
    }
    return( NULL );
}

/* USBIO Open */
struct usb_dev_handle *io_open(struct usb_device *dev)
{
    struct usb_dev_handle *udev = NULL;

    udev=usb_open(dev);
    if( (udev=usb_open(dev))==NULL ){
        printf("usb_open Error.(%s)\n",usb_strerror());
        exit(1);
    }

    if( usb_set_configuration(udev,dev->config->bConfigurationValue)<0 ){
        if( usb_detach_kernel_driver_np(udev,dev->config->interface->altsetting->bInterfaceNumber)<0 ){
            printf("usb_set_configuration Error.\n");
            printf("usb_detach_kernel_driver_np Error.(%s)\n",usb_strerror());
        }
    }

    if( usb_claim_interface(udev,dev->config->interface->altsetting->bInterfaceNumber)<0 ){
        if( usb_detach_kernel_driver_np(udev,dev->config->interface->altsetting->bInterfaceNumber)<0 ){
            printf("usb_claim_interface Error.\n");
            printf("usb_detach_kernel_driver_np Error.(%s)\n",usb_strerror());
        }
    }

    if( usb_claim_interface(udev,dev->config->interface->altsetting->bInterfaceNumber)<0 ){
        printf("usb_claim_interface Error.(%s)\n",usb_strerror());
    }

    return(udev);
}

/* USBIO Close */
void io_close(struct usb_dev_handle *udev)
{
    if( usb_close(udev)<0 ){
        printf("usb_close Error.(%s)\n",usb_strerror());
    }
}

/* USB-IO Family Send Recive */
int io_send_recv(struct usb_dev_handle *udev, unsigned char *sendData, unsigned char *recvData )
{
    static unsigned char seq;
    int ret;
    int i;
    int sendLen;
    int recvLen;

    seq++;
    sendData[63] = seq;

    ret = usb_bulk_write(udev, 1, sendData, 64, 1000);
    if( ret < 0 ){
        printf("Send-Error (%d)\n", ret);
        return (-1);
    }
    if(ret != 64){
        printf("Send-Len Error %d\n",sendLen);
        return (-2);
    }

    for (i=0; i<20; i++) { 
        ret = usb_bulk_read(udev, 1, recvData, 64, 100);
        if (ret == 64 && sendData[63] == recvData[63]) {
            //Read OK!
            return (0);
        }
        printf("Read Skip(%d)\n",ret);
        usleep(1000);
    }

    printf("Read Data Error\n");
    return (-4);
}


