/*----------------------------*/
/* USB-IO Family TEST         */
/*----------------------------*/

#include <stdio.h>
#include <string.h>
#include <usb.h>
#include "usbiofamily.h"

int main(int argc, char **argv)
{
    int ret;
    int dat;

    struct usb_bus    *bus;
    struct usb_device *dev;
    usb_dev_handle    *udev;

    unsigned char sendData[64];
    unsigned char recvData[64];

    /*-------------*/
    /* Device Open */
    /*-------------*/
    bus=io_init();
    dev=io_find(bus,dev);
    if( dev==NULL ){ 
        puts("io_find NG");
        exit(1);
    }
    
    udev=io_open(dev);
    if( udev==NULL ){
        puts("io_open NG");
        exit(2);
    }

    /*------------------------*/
    /* Port 1,2 in_out        */
    /*------------------------*/
    memset(sendData, 0, sizeof(sendData));
    sendData[0] = 0x20;     //in out
    sendData[1] = 0x01;     //port1
    sendData[2] = 0x03;     //out 0x03
    sendData[3] = 0x02;     //port2
    sendData[4] = 0x07;     //out 0x07
    io_send_recv(udev,sendData,recvData);
    printf("in:P1(%x),P2(%x)  out:P1(%x),P2(%x)\n"
            ,recvData[1],recvData[2], sendData[2],sendData[4]);

    /*------------------------*/
    /* channel 1, 2 Analog input */
    /*------------------------*/
    memset(sendData, 0, sizeof(sendData));
    sendData[0] = 0x2A;     //Analog input
    sendData[1] = 0x01;     //channel 1
    sendData[4] = 0x02;     //channel 2
    io_send_recv(udev,sendData,recvData);
    printf("Analog:C1(%x),C2(%x)\n",recvData[2] | (recvData[3]<<8), recvData[5] | (recvData[6]<<8) );

    /*---------------------*/
    /* Device Close & Exit */
    /*---------------------*/
    io_close(udev);
    exit(0);
}


