﻿Imports USB_IO_Family

Public Class Form1

    Private io As New USB_IO_Family.ioCtl

    Private Sub btnConnect_Click(sender As System.Object, e As System.EventArgs) Handles btnConnect.Click
        io.openDevice()
        If io.gDeviceCnt > 0 Then
            btnConnect.Enabled = False
        Else
            MsgBox("USB-FSIOを接続してください")
        End If

    End Sub

    Private Sub btnGetData_Click(sender As System.Object, e As System.EventArgs) Handles btnGetData.Click

        Dim oscFmt As ioCtl.ST_CTL_OSC_FMT
        Dim oscFmtLen As Integer

        oscFmt.Period = CInt(txtPeriod.Text)    'データ取得周期設定
        ReDim oscFmt.OscFmt(3)                  'データ取得フォーマット設定
        oscFmt.OscFmt(0) = ioCtl.OSC_FMT_AD10 + CInt(txtFmt1Ch.Text)
        oscFmt.OscFmt(1) = ioCtl.OSC_FMT_AD08 + CInt(txtFmt2Ch.Text)
        oscFmt.OscFmt(2) = ioCtl.OSC_FMT_DI + CInt(txtFmt3Port.Text)

        '設定データ送信
        oscFmtLen = io.ctlOscFmtSet(oscFmt)
        If oscFmtLen <= 0 Then
            MsgBox("設定失敗")
            Return
        End If

        '初回データの読み捨て
        Dim oscData As ioCtl.ST_CTL_OSC_INPUT
        io.ctlOscInput(oscData)


        'データ取得
        Dim grpCh1 As Graphics = picMon1.CreateGraphics()
        Dim grpCh2 As Graphics = picMon2.CreateGraphics()
        Dim iFmtNo As Integer
        Dim iCnt As Integer
        Dim iOscDt1() As Integer
        Dim iOscDt2() As Integer
        Dim iOscDt3() As Integer
        Dim iDtPt As Integer = 0

        ReDim iOscDt1(CInt(txtDataMax.Text))
        ReDim iOscDt2(CInt(txtDataMax.Text))
        ReDim iOscDt3(CInt(txtDataMax.Text))

        While (True)

            If io.ctlOscInput(oscData) <> ioCtl.ERR_NONE Then
                MsgBox("受信失敗")
                Return
            End If

            For iCnt = 0 To (oscData.OscDataLenB / oscFmtLen) - 1
                For iFmtNo = 0 To 2
                    'あふれた部分は異常値セット
                    If (iCnt * oscFmtLen) >= ioCtl.OSC_RCV_MAX_LENB Then
                        iOscDt1(iDtPt) = -1
                        iOscDt2(iDtPt) = -1
                        iOscDt3(iDtPt) = -1
                    Else
                        'データ取得 フォーマット変換
                        Select Case iFmtNo
                            Case 0
                                iOscDt1(iDtPt) = oscData.OscData(iCnt * oscFmtLen) + oscData.OscData((iCnt * oscFmtLen) + 1) * &H100     '10Bit
                            Case 1
                                iOscDt2(iDtPt) = oscData.OscData((iCnt) * oscFmtLen + 2)           '8Bit
                            Case 2
                                iOscDt3(iDtPt) = oscData.OscData((iCnt) * oscFmtLen + 3)           'DI
                        End Select
                    End If

                Next
                '取得終了判定
                iDtPt += 1
                If iDtPt >= CInt(txtDataMax.Text) Then
                    Exit While
                End If
            Next
        End While

        '取得データ一覧表示
        Dim sWk As String = ""
        For iCnt = 0 To CInt(txtDataMax.Text) - 1
            sWk = sWk & String.Format("{0:0000}:{1:0000},{2:0000},0x{3:x}", iCnt, iOscDt1(iCnt), iOscDt2(iCnt), iOscDt3(iCnt)) & vbCrLf
        Next
        txtData.Text = sWk

        '取得データグラフ表示
        grpCh1.Clear(Color.Black)
        grpCh2.Clear(Color.Black)
        Dim iDsp As Integer = 4
        For iCnt = 1 To iDtPt - 1
            '10Bitデータ縮小表示
            grpCh1.DrawLine(Pens.White, (iCnt - 1) * iDsp, (256 - (iOscDt1(iCnt - 1) >> 2)) _
                                          , (iCnt) * iDsp, (256 - (iOscDt1(iCnt) >> 2)))
            '8Bitデータ表示
            grpCh2.DrawLine(Pens.White, (iCnt - 1) * iDsp, (256 - iOscDt2(iCnt - 1)) _
                                          , (iCnt) * iDsp, (256 - iOscDt2(iCnt)))
            If iCnt * iDsp >= picMon1.Width Then
                Exit For
            End If

        Next
    End Sub

End Class
