package com.km2net.android.pkgUSBIOFamily_IoSample;

import java.util.Arrays;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

public class USBIO_Family_IoSampleActivity extends Activity implements OnClickListener {
	private UsbManager			mUsbManager;
	private UsbDeviceConnection	mConnection;
	private PendingIntent		mPermissionIntent;
	private UsbDevice			mUsbDevice;
	private UsbInterface		mIntf = null;
	private BroadcastReceiver	mUsbReceiver = new UsbBroadcastReceiver();

    private static final String ACTION_USB_PERMISSION = "com.km2net.android.USB_IO_FAMILY_PERMISSION";
    private static final String D_TAG= "USB-IO Family";

    public final int VENDOR_ID		= 0x1352;
    public final int PRODUCT_ID[]	= {0x0110,0x0111,0x0120,0x0121};

    private Button btnConnect;
    private Button btnSendRecv;
    private EditText edtOutPort;
    private EditText edtOutValue;
    private TextView txvConnect;
    private TextView txvRecv;

	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        btnConnect	=(Button)	findViewById(R.id.btnConnect);
        btnSendRecv	=(Button)	findViewById(R.id.btnSendRecv);
        edtOutPort	=(EditText)	findViewById(R.id.edtOutPort);
        edtOutValue	=(EditText)	findViewById(R.id.edtOutValue);
        txvConnect	=(TextView)	findViewById(R.id.txvConnect);
        txvRecv		=(TextView)	findViewById(R.id.txvRecv);

        btnConnect.setOnClickListener(this);
        btnSendRecv.setOnClickListener(this);
    	txvConnect.setText("unconnected");

	    mUsbManager = (UsbManager)getSystemService(Context.USB_SERVICE);
	    mPermissionIntent = PendingIntent.getBroadcast(this, 0, new Intent(ACTION_USB_PERMISSION), 0);

	    IntentFilter filter = new IntentFilter();
	    filter.addAction(ACTION_USB_PERMISSION);
        filter.addAction(UsbManager.ACTION_USB_DEVICE_DETACHED);
	    registerReceiver(mUsbReceiver, filter);
    }

	public void onClick(View arg0) {
		if (arg0.getId() == R.id.btnConnect) {
	        for (UsbDevice device :  mUsbManager.getDeviceList().values()) {
	        	if (device.getVendorId() == VENDOR_ID
		        &&  Arrays.binarySearch(PRODUCT_ID, device.getProductId()) >= 0) {
	        		mUsbManager.requestPermission(device, mPermissionIntent);
	    		}
	        }
		}
		else if (arg0.getId() == R.id.btnSendRecv && mIntf != null) {
			try {
				byte bt[] = new byte[64];
	            bt[0]	= 0x20;
	            bt[1]	= Byte.valueOf(edtOutPort.getText().toString());
	            bt[2]	= (byte)Integer.parseInt(edtOutValue.getText().toString(),2);

	            int iSendLen;
	            iSendLen = mConnection.bulkTransfer(mIntf.getEndpoint(1), bt, 64, 1000);
	            Log.d(D_TAG, "Send:" + String.valueOf(iSendLen) + ", Data(Hex):" + Integer.toHexString(bt[0]) + ',' + Integer.toHexString(bt[1]) + Integer.toHexString(bt[2]));
	            iSendLen = mConnection.bulkTransfer(mIntf.getEndpoint(0), bt, 64, 1000);
	            Log.d(D_TAG, "Recive:" + String.valueOf(iSendLen) + ", Data(Hex):" + Integer.toHexString(bt[0]) + ',' + Integer.toHexString(bt[1]) + Integer.toHexString(bt[2]) + ',' + Integer.toHexString(bt[3]) + Integer.toHexString(bt[4]));

	            if ((mUsbDevice.getProductId() & 0x0110) == 0x110) {
	            	txvRecv.setText("Port1:" + toBinaryString(bt[1]) + ", Port2:" + toBinaryString(bt[2]) + ", Port3:" + toBinaryString(bt[3]) + ", Port4:" + toBinaryString(bt[4]) );
	            }
	            else {
	            	txvRecv.setText("Port1:" + toBinaryString(bt[1]) + ", Port2:" + toBinaryString(bt[2]) );
	    		}
			}
			catch (Exception e) {
				Toast.makeText(this, e.toString(), Toast.LENGTH_LONG);
			}
   		}
	}

	public String toBinaryString(byte bData) {
		String sRet = "00000000" + Integer.toBinaryString(bData);
		return sRet.substring(sRet.length()-8, sRet.length());
	}

	private class UsbBroadcastReceiver extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            mUsbDevice = (UsbDevice)intent.getParcelableExtra(UsbManager.EXTRA_DEVICE);
            if (ACTION_USB_PERMISSION.equals(action) && mIntf == null) {
    	        mIntf = mUsbDevice.getInterface(0);
    	        if (mUsbDevice != null) {
    	            mConnection = mUsbManager.openDevice(mUsbDevice);
    	            if (mConnection != null) {
    	    	        if ( mConnection.claimInterface(mIntf, true)) {
    	    	        	txvConnect.setText("Connect ProductID:0x" + Integer.toHexString(mUsbDevice.getProductId()));
    	    	        }
    	            }
    	            else {
	    	        	txvConnect.setText("Connect failure");
    	            }
    	        }
            }

            if (UsbManager.ACTION_USB_DEVICE_DETACHED.equals(action) && mIntf != null) {
            	mConnection.releaseInterface(mIntf);
            	mConnection.close();
            	mIntf=null;
            	txvConnect.setText("unconnected");
           }
    	}
    }
}